// Code generated from shared/sources.json. DO NOT EDIT.
// Run build to regenerate.

const BLOCKED_SOURCES = new Set([
  "aa.com",
  "airbnb.com",
  "airtable.com",
  "alibaba.com",
  "aliexpress.com",
  "allrecipes.com",
  "amazon.com",
  "americanexpress.com",
  "answers.com",
  "apple.com",
  "archive.is",
  "archive.org",
  "asana.com",
  "ask.com",
  "aws.amazon.com",
  "azure.microsoft.com",
  "baidu.com",
  "bankofamerica.com",
  "battle.net",
  "bestbuy.com",
  "binance.com",
  "bing.com",
  "bit.ly",
  "bitbucket.org",
  "bitchute.com",
  "blizzard.com",
  "bonappetit.com",
  "booking.com",
  "box.com",
  "britannica.com",
  "bsky.app",
  "buymeacoffee.com",
  "calendar.google.com",
  "canva.com",
  "capitalone.com",
  "cashapp.com",
  "change.org",
  "chase.com",
  "cloud.google.com",
  "codepen.io",
  "codesandbox.io",
  "coinbase.com",
  "costco.com",
  "crates.io",
  "crunchyroll.com",
  "crypto.com",
  "dailymotion.com",
  "deezer.com",
  "delta.com",
  "dictionary.com",
  "digitalocean.com",
  "discord.com",
  "discover.com",
  "disneyplus.com",
  "docs.google.com",
  "doordash.com",
  "drive.google.com",
  "dropbox.com",
  "duckduckgo.com",
  "ea.com",
  "ebay.com",
  "epicgames.com",
  "epicurious.com",
  "etsy.com",
  "eventbrite.com",
  "evernote.com",
  "expedia.com",
  "facebook.com",
  "fidelity.com",
  "figma.com",
  "foodnetwork.com",
  "forms.gle",
  "genius.com",
  "gfycat.com",
  "giphy.com",
  "github.com",
  "gitlab.com",
  "gmail.com",
  "gofundme.com",
  "gog.com",
  "goo.gl",
  "goodreads.com",
  "google.com",
  "grubhub.com",
  "hbomax.com",
  "heroku.com",
  "homedepot.com",
  "hotels.com",
  "hub.docker.com",
  "hulu.com",
  "ikea.com",
  "imdb.com",
  "imgur.com",
  "instacart.com",
  "instagram.com",
  "jetblue.com",
  "jsfiddle.net",
  "kayak.com",
  "kickstarter.com",
  "ko-fi.com",
  "kraken.com",
  "leagueoflegends.com",
  "linkedin.com",
  "linktr.ee",
  "lowes.com",
  "mail.google.com",
  "mastodon.social",
  "max.com",
  "meet.google.com",
  "meetup.com",
  "merriam-webster.com",
  "messenger.com",
  "minecraft.net",
  "miro.com",
  "monday.com",
  "music.apple.com",
  "netflix.com",
  "netlify.com",
  "newegg.com",
  "nintendo.com",
  "notion.so",
  "npmjs.com",
  "odysee.com",
  "onedrive.live.com",
  "opentable.com",
  "outlook.com",
  "overstock.com",
  "pandora.com",
  "paramountplus.com",
  "pastebin.com",
  "patreon.com",
  "paypal.com",
  "peacocktv.com",
  "pinterest.com",
  "playstation.com",
  "postmates.com",
  "priceline.com",
  "primevideo.com",
  "proton.me",
  "pypi.org",
  "quora.com",
  "redd.it",
  "reddit.com",
  "reddit.com",
  "replit.com",
  "robinhood.com",
  "roblox.com",
  "rottentomatoes.com",
  "rubygems.org",
  "rumble.com",
  "schwab.com",
  "seriouseats.com",
  "sheets.google.com",
  "shopify.com",
  "slack.com",
  "slides.google.com",
  "snapchat.com",
  "soundcloud.com",
  "southwest.com",
  "spotify.com",
  "steampowered.com",
  "store.steampowered.com",
  "surveymonkey.com",
  "t.co",
  "target.com",
  "teams.microsoft.com",
  "telegram.org",
  "tenor.com",
  "thesaurus.com",
  "threads.net",
  "tidal.com",
  "tiktok.com",
  "tiktok.com",
  "tinyurl.com",
  "trello.com",
  "tripadvisor.com",
  "trivago.com",
  "tumblr.com",
  "twitch.tv",
  "twitch.tv",
  "twitter.com",
  "typeform.com",
  "ubereats.com",
  "ubisoft.com",
  "united.com",
  "urbandictionary.com",
  "vanguard.com",
  "venmo.com",
  "vercel.com",
  "vimeo.com",
  "vrbo.com",
  "walmart.com",
  "wayfair.com",
  "web.archive.org",
  "wellsfargo.com",
  "whatsapp.com",
  "wikihow.com",
  "wikimedia.org",
  "wikipedia.org",
  "wiktionary.org",
  "wish.com",
  "x.com",
  "xbox.com",
  "yahoo.com",
  "yandex.com",
  "yelp.com",
  "youtu.be",
  "youtube.com",
  "zoom.us",
]);

const BLOCKED_PATTERNS = [
  "*.edu",
  "*.gov",
  "*.mil",
];

function isBlockedSource(url) {
  try {
    const host = new URL(url).hostname.toLowerCase().replace(/^www\./, '');
    
    // Check exact match
    if (BLOCKED_SOURCES.has(host)) return true;
    
    // Check subdomain of blocked source
    for (const domain of BLOCKED_SOURCES) {
      if (host.endsWith('.' + domain)) return true;
    }
    
    // Check blocked patterns (e.g., *.edu, *.gov)
    for (const pattern of BLOCKED_PATTERNS) {
      const suffix = pattern.replace(/^\*/, '');
      if (host.endsWith(suffix) || host === suffix.replace(/^\./, '')) return true;
    }
    
    return false;
  } catch {
    return true; // Block if we can't parse
  }
}

// isAllowedSource is the inverse of isBlockedSource for API compatibility
function isAllowedSource(url) {
  return !isBlockedSource(url);
}
