// Popup script for Boringfy toggle

const toggle = document.getElementById('toggle');
const status = document.getElementById('status');

// Load current state
browser.storage.local.get('enabled').then((result) => {
  // Default to enabled if not set
  const enabled = result.enabled !== false;
  toggle.checked = enabled;
  updateStatus(enabled);
});

// Handle toggle change
toggle.addEventListener('change', () => {
  const enabled = toggle.checked;
  
  // Save state
  browser.storage.local.set({ enabled });
  
  // Update status text
  updateStatus(enabled);
  
  // Notify all Reddit tabs to update
  browser.tabs.query({ url: '*://*.reddit.com/*' }).then((tabs) => {
    tabs.forEach((tab) => {
      browser.tabs.sendMessage(tab.id, { 
        type: 'toggle', 
        enabled 
      }).catch(() => {
        // Tab might not have content script loaded yet
      });
    });
  });
});

function updateStatus(enabled) {
  if (enabled) {
    status.textContent = 'Replacing clickbait with boring titles';
    status.style.color = '#666';
  } else {
    status.textContent = 'Disabled - showing original titles';
    status.style.color = '#999';
  }
}
